/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.httpbuilder;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Observable;
import net.noip.codebox.httpbuilder.HttpRequest;
import net.noip.codebox.httpbuilder.ProxyConfig;
import net.noip.codebox.httpbuilder.RequestHeader;
import net.noip.codebox.httpbuilder.util.Utils;

public class HttpModel
extends Observable {
    private String latestResponse;
    private int receivedCount;
    private HttpModelState state;
    Socket socket = null;

    public void setState(HttpModelState newState) {
        this.state = newState;
        this.setChanged();
        this.notifyObservers((Object)NotificationType.STATE_CHANGE);
    }

    void send(HttpRequest request, ProxyConfig proxyConfig) {
        String host = null;
        try {
            int port;
            if (proxyConfig.isUseProxy()) {
                host = proxyConfig.getProxyHost();
                port = proxyConfig.getProxyPort();
                String proxyUser = proxyConfig.getProxyUser();
                String proxyPass = proxyConfig.getProxyPass();
                if (proxyUser != null && proxyPass != null) {
                    HttpRequest.HeaderValue proxyAuthHeader = new HttpRequest.HeaderValue();
                    proxyAuthHeader.header = new RequestHeader("Proxy-Authorization");
                    proxyAuthHeader.value = "Basic " + Utils.base64Encode(String.valueOf(proxyUser) + ":" + proxyPass);
                    request.addHeader(proxyAuthHeader);
                }
            } else {
                host = request.getUrl().getHost();
                port = request.getUrl().getPort();
            }
            String requestText = request.getRequestText(proxyConfig);
            String response = this.sendToSocket(requestText, host, port);
            this.setLatestResponse(response);
        }
        catch (IllegalArgumentException ex) {
            this.setLatestResponse(ex.getMessage());
        }
        catch (UnknownHostException ex) {
            this.setLatestResponse("Unable to locate the host '" + host + "', check your proxy settings");
        }
        catch (NoRouteToHostException ex) {
            this.setLatestResponse("Unable to find a route to the '" + host + "', check your network configuration settings");
        }
        catch (IOException ex) {
            this.setLatestResponse(ex.getMessage());
        }
    }

    void cancelPendingRequests() {
        if (this.socket != null && !this.socket.isClosed()) {
            try {
                this.socket.close();
                this.setState(HttpModelState.DISCONNECTED);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String sendToSocket(String data, String host, int port) throws IOException {
        PrintWriter out = null;
        BufferedReader in = null;
        String response = "";
        try {
            String responseLine;
            long currentTime;
            this.socket = new Socket(host, port);
            this.setState(HttpModelState.CONNECTED_PASSIVE);
            out = new PrintWriter(this.socket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.setState(HttpModelState.SENDING);
            out.write(data);
            out.flush();
            this.setState(HttpModelState.AWAITING_RESPONSE);
            int byteCount = 0;
            long lastUpdateTime = currentTime = new Date().getTime();
            while ((responseLine = in.readLine()) != null) {
                this.setReceivedCount(byteCount += responseLine.length() + 1);
                currentTime = new Date().getTime();
                if (currentTime > lastUpdateTime + 1000L) {
                    this.setState(HttpModelState.RECEIVING);
                    lastUpdateTime = currentTime;
                }
                response = String.valueOf(response) + responseLine;
                response = String.valueOf(response) + "\n";
            }
            this.setState(HttpModelState.CONNECTED_PASSIVE);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
            this.setState(HttpModelState.DISCONNECTED);
        }
        return response;
    }

    public synchronized int getReceivedCount() {
        return this.receivedCount;
    }

    private synchronized void setReceivedCount(int receivedCount) {
        this.receivedCount = receivedCount;
    }

    public HttpModelState getState() {
        return this.state;
    }

    public String getLatestResponse() {
        return this.latestResponse;
    }

    public void setLatestResponse(String latestResponse) {
        this.latestResponse = latestResponse;
        this.setChanged();
        this.notifyObservers((Object)NotificationType.NEW_DATA);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum HttpModelState {
        DISCONNECTED,
        CONNECTED_PASSIVE,
        SENDING,
        AWAITING_RESPONSE,
        RECEIVING;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NotificationType {
        STATE_CHANGE,
        NEW_DATA;

    }
}

