/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.httpbuilder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.noip.codebox.httpbuilder.HttpUrl;
import net.noip.codebox.httpbuilder.ProxyConfig;
import net.noip.codebox.httpbuilder.RequestHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequest
implements Serializable {
    private HttpUrl url;
    private Method method;
    private HttpVersion httpVersion;
    private List<HeaderValue> headers;

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)obj;
            HttpUrl otherUrl = req.getUrl();
            Method otherMethod = req.getMethod();
            HttpVersion otherHttpVersion = req.getHttpVersion();
            List<HeaderValue> otherHeaders = req.getHeaders();
            boolean isEqual = (otherUrl == null ? this.url == null : otherUrl.equals(this.url)) && (otherMethod == null ? this.method == null : otherMethod.equals((Object)this.method)) && (otherHttpVersion == null ? this.httpVersion == null : otherHttpVersion.equals((Object)this.httpVersion)) && (otherHeaders == null ? this.headers == null : otherHeaders.equals(this.headers));
            return isEqual;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 37 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 37 * result + (this.httpVersion == null ? 0 : this.httpVersion.hashCode());
        result = 37 * result + (this.headers == null ? 0 : this.headers.hashCode());
        return result;
    }

    public HttpRequest(Method method, HttpUrl url, HttpVersion httpVersion, List<HeaderValue> headers) {
        this.method = method;
        this.url = url;
        this.httpVersion = httpVersion;
        this.headers = new ArrayList<HeaderValue>(headers);
    }

    public synchronized void addHeader(HeaderValue header) {
        this.headers.add(header);
    }

    public HttpUrl getUrl() {
        return this.url;
    }

    public Method getMethod() {
        return this.method;
    }

    public HttpVersion getHttpVersion() {
        return this.httpVersion;
    }

    public List<HeaderValue> getHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    public String toString() {
        return this.getUrl().getFormattedUrl();
    }

    public synchronized String getRequestText(ProxyConfig proxyConfig) {
        StringBuilder text = new StringBuilder();
        text.append(this.method.toString());
        text.append(" ");
        if (proxyConfig.isUseProxy()) {
            text.append(this.url.getFormattedUrl());
        } else {
            text.append("/");
            text.append(this.url.getPathWithQueryString());
        }
        text.append(" ");
        text.append(this.httpVersion.toString());
        for (HeaderValue header : this.headers) {
            text.append("\r\n");
            text.append(header.toString());
        }
        text.append("\r\n\r\n");
        return text.toString();
    }

    public static class HeaderValue
    implements Serializable {
        public RequestHeader header;
        public String value;

        public String toString() {
            return this.header + ": " + this.value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof HeaderValue) {
                HeaderValue headerObj = (HeaderValue)obj;
                String otherValue = headerObj.value;
                RequestHeader otherHeader = headerObj.header;
                boolean isEqual = (otherValue == null ? this.value == null : otherValue.equals(this.value)) && (otherHeader == null ? this.header == null : otherHeader.equals(this.header));
                return isEqual;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.value == null ? 0 : this.value.hashCode());
            result = 37 * result + (this.header == null ? 0 : this.header.hashCode());
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum HttpVersion {
        V1_0("1.0"),
        V1_1("1.1");

        private String value;

        private HttpVersion(String value) {
            this.value = value;
        }

        public String toString() {
            return "HTTP/" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method {
        GET,
        POST,
        HEAD,
        PUT,
        DELETE,
        OPTIONS,
        TRACE,
        CONNECT;


        public String toString() {
            return this.name();
        }
    }
}

