/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.httpbuilder.headerhelpers;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.noip.codebox.httpbuilder.headerhelpers.HeaderHelperBase;
import net.noip.codebox.httpbuilder.headerhelpers.NumericInputFilter;
import net.noip.codebox.httpbuilder.headerhelpers.panels.IPanel;
import net.noip.codebox.httpbuilder.headerhelpers.panels.ListPanel;
import net.noip.codebox.httpbuilder.headerhelpers.panels.PanelChangeListener;
import net.noip.codebox.httpbuilder.headerhelpers.panels.RadioButtonPanel;
import net.noip.codebox.httpbuilder.headerhelpers.panels.TextPanel;
import net.noip.codebox.httpbuilder.util.Utils;

public class AuthorizationHeaderHelper
extends HeaderHelperBase {
    private static final Dimension BOX_SIZE = new Dimension(1000, 20);
    private JTextField txtResult;
    private RadioButtonPanel radioPanel;
    private static final String BASIC = "Basic";
    private static final String DIGEST = "Digest";
    IPanel basicUserPanel;
    IPanel basicPassPanel;
    IPanel digestUserPanel;
    IPanel digestPassPanel;
    IPanel digestRealmPanel;
    IPanel digestMethodPanel;
    IPanel digestURIPanel;
    IPanel digestServerNoncePanel;
    IPanel digestNonceCountPanel;
    IPanel digestClientNoncePanel;
    IPanel digestOpaquePanel;

    public String getTitle() {
        return "Authorization Header Helper";
    }

    protected void setupCustomGui(JPanel mainPanel) {
        mainPanel.add(this.makeBasicPanel());
        mainPanel.add(this.makeDigestPanel());
        mainPanel.add(this.makeButtonPanel());
        mainPanel.add(this.makeResultPanel());
        this.radioPanel.setValue(BASIC);
        this.setGuiState();
    }

    private JPanel makeButtonPanel() {
        this.radioPanel = new RadioButtonPanel(new String[]{BASIC, DIGEST});
        this.radioPanel.addChangeListener(new PanelChangeListener(){

            public void onChange(IPanel panel) {
                AuthorizationHeaderHelper.this.setGuiState();
            }
        });
        JPanel panel = this.radioPanel.getPanel();
        JButton button = new JButton("Calculate");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AuthorizationHeaderHelper.this.setGuiState();
            }
        });
        panel.add(button);
        return panel;
    }

    private void setGuiState() {
        if (BASIC.equals(this.radioPanel.getValue())) {
            this.setBasicPanelState(true);
            this.setDigestPanelState(false);
            this.txtResult.setText(this.getBasicValue());
        } else if (DIGEST.equals(this.radioPanel.getValue())) {
            this.setBasicPanelState(false);
            this.setDigestPanelState(true);
            this.txtResult.setText(this.getDigestValue());
        } else {
            this.setBasicPanelState(false);
            this.setDigestPanelState(false);
            this.txtResult.setText("");
        }
    }

    private void setBasicPanelState(boolean enabled) {
        this.basicUserPanel.setEnabled(enabled);
        this.basicPassPanel.setEnabled(enabled);
    }

    private String getBasicValue() {
        String preHash = String.valueOf(this.basicUserPanel.getValue()) + ":" + this.basicPassPanel.getValue();
        return Utils.base64Encode(preHash);
    }

    private void setDigestPanelState(boolean enabled) {
        this.digestUserPanel.setEnabled(enabled);
        this.digestPassPanel.setEnabled(enabled);
        this.digestRealmPanel.setEnabled(enabled);
        this.digestMethodPanel.setEnabled(enabled);
        this.digestURIPanel.setEnabled(enabled);
        this.digestServerNoncePanel.setEnabled(enabled);
        this.digestNonceCountPanel.setEnabled(enabled);
        this.digestClientNoncePanel.setEnabled(enabled);
        this.digestOpaquePanel.setEnabled(enabled);
    }

    private String getDigestValue() {
        String user = this.digestUserPanel.getValue();
        String realm = this.digestRealmPanel.getValue();
        String password = this.digestPassPanel.getValue();
        String method = this.digestMethodPanel.getValue();
        String uri = this.digestURIPanel.getValue();
        String serverNonce = this.digestServerNoncePanel.getValue();
        String clientNonce = this.digestClientNoncePanel.getValue();
        String nonceCount = this.digestNonceCountPanel.getValue();
        String qop = "auth";
        String opaque = this.digestOpaquePanel.getValue();
        String preHash1 = String.valueOf(user) + ":" + realm + ":" + password;
        String hash1 = Utils.getMD5Hash(preHash1);
        String preHash2 = String.valueOf(method) + ":" + uri;
        String hash2 = Utils.getMD5Hash(preHash2);
        String preResponseHash = String.valueOf(hash1) + ":" + serverNonce + ":" + nonceCount + ":" + clientNonce + ":" + qop + ":" + hash2;
        String responseHash = Utils.getMD5Hash(preResponseHash);
        StringBuilder result = new StringBuilder();
        result.append("username=\"");
        result.append(user);
        result.append("\", realm=\"");
        result.append(realm);
        result.append("\", nonce=\"");
        result.append(serverNonce);
        result.append("\", uri=\"");
        result.append(uri);
        result.append("\", qop=");
        result.append(qop);
        result.append(", nc=");
        result.append(nonceCount);
        result.append(", cnonce=\"");
        result.append(clientNonce);
        result.append("\", response=\"");
        result.append(responseHash);
        result.append("\", opaque=\"");
        result.append(opaque);
        result.append("\"");
        return result.toString();
    }

    private JPanel makeBasicPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.basicUserPanel = new TextPanel("User");
        panel.add(this.basicUserPanel.getPanel());
        this.basicPassPanel = new TextPanel("Password", true);
        panel.add(this.basicPassPanel.getPanel());
        return panel;
    }

    protected String getValue() {
        if (BASIC.equals(this.radioPanel.getValue())) {
            return "BASIC " + this.txtResult.getText();
        }
        if (DIGEST.equals(this.radioPanel.getValue())) {
            return "Digest " + this.txtResult.getText();
        }
        return "";
    }

    private JPanel makeDigestPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.digestUserPanel = new TextPanel("User");
        panel.add(this.digestUserPanel.getPanel());
        this.digestPassPanel = new TextPanel("Password", true);
        panel.add(this.digestPassPanel.getPanel());
        this.digestRealmPanel = new TextPanel("Realm");
        panel.add(this.digestRealmPanel.getPanel());
        this.digestMethodPanel = new ListPanel("HTTP Method");
        this.digestMethodPanel.setData(new String[]{"GET", "POST"});
        panel.add(this.digestMethodPanel.getPanel());
        this.digestURIPanel = new TextPanel("URI");
        panel.add(this.digestURIPanel.getPanel());
        this.digestServerNoncePanel = new TextPanel("Server Nonce");
        panel.add(this.digestServerNoncePanel.getPanel());
        this.digestNonceCountPanel = new TextPanel("Nonce Count");
        ((TextPanel)this.digestNonceCountPanel).setFilter(new NumericInputFilter());
        panel.add(this.digestNonceCountPanel.getPanel());
        this.digestClientNoncePanel = new TextPanel("Client Nonce");
        panel.add(this.digestClientNoncePanel.getPanel());
        this.digestOpaquePanel = new TextPanel("Opaque Value");
        panel.add(this.digestOpaquePanel.getPanel());
        return panel;
    }

    private JPanel makeResultPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createRigidArea(new Dimension(10, 30)));
        this.txtResult = new JTextField();
        panel.add(this.txtResult);
        panel.add(Box.createHorizontalStrut(10));
        this.txtResult.setMaximumSize(BOX_SIZE);
        return panel;
    }
}

