/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.httpbuilder.headerhelpers;

import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.noip.codebox.httpbuilder.headerhelpers.HeaderHelperBase;
import net.noip.codebox.httpbuilder.headerhelpers.NumericInputFilter;
import net.noip.codebox.httpbuilder.headerhelpers.panels.CheckboxPanel;
import net.noip.codebox.httpbuilder.headerhelpers.panels.ETagPanel;
import net.noip.codebox.httpbuilder.headerhelpers.panels.IPanel;
import net.noip.codebox.httpbuilder.headerhelpers.panels.ListPanel;
import net.noip.codebox.httpbuilder.headerhelpers.panels.PanelChangeListener;
import net.noip.codebox.httpbuilder.headerhelpers.panels.RangePanel;
import net.noip.codebox.httpbuilder.headerhelpers.panels.TextPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldBasedHeaderHelper
extends HeaderHelperBase {
    private static final Dimension BOX_SIZE = new Dimension(1000, 20);
    protected Map<String, IPanel> fields = new HashMap<String, IPanel>();
    protected JTextField txtResult;

    @Override
    protected String getValue() {
        return this.txtResult.getText();
    }

    protected void setValue(String value) {
        this.txtResult.setText(value);
    }

    @Override
    protected void setupCustomGui(JPanel mainPanel) {
        for (Map.Entry<String, FieldType> field : this.getFields().entrySet()) {
            mainPanel.add(this.makeFieldPanel(field.getKey(), field.getValue()));
        }
        this.addExtras(mainPanel);
        mainPanel.add(this.makeResultPanel());
    }

    protected void addExtras(JPanel mainPanel) {
    }

    private JPanel makeFieldPanel(String labelText, FieldType fieldType) {
        IPanel panel;
        if (fieldType == FieldType.CHECKBOX) {
            CheckboxPanel chkPanel = new CheckboxPanel(labelText);
            chkPanel.addChangeListener(new PanelChangeListener(){

                public void onChange(IPanel panel) {
                    FieldBasedHeaderHelper.this.onFieldValueChanged();
                }
            });
            panel = chkPanel;
        } else if (fieldType == FieldType.ETAG) {
            ETagPanel eTagPanel = new ETagPanel(labelText);
            eTagPanel.addChangeListener(new PanelChangeListener(){

                public void onChange(IPanel panel) {
                    FieldBasedHeaderHelper.this.onFieldValueChanged();
                }
            });
            panel = eTagPanel;
        } else if (fieldType == FieldType.LIST) {
            ListPanel eTagPanel = new ListPanel(labelText);
            eTagPanel.addChangeListener(new PanelChangeListener(){

                public void onChange(IPanel panel) {
                    FieldBasedHeaderHelper.this.onFieldValueChanged();
                }
            });
            panel = eTagPanel;
        } else if (fieldType == FieldType.RANGE) {
            RangePanel rangePanel = new RangePanel(labelText);
            rangePanel.addChangeListener(new PanelChangeListener(){

                public void onChange(IPanel panel) {
                    FieldBasedHeaderHelper.this.onFieldValueChanged();
                }
            });
            panel = rangePanel;
        } else {
            TextPanel textPanel = new TextPanel(labelText);
            if (fieldType == FieldType.NUMERIC) {
                textPanel.setFilter(new NumericInputFilter());
            }
            textPanel.addChangeListener(new PanelChangeListener(){

                public void onChange(IPanel panel) {
                    FieldBasedHeaderHelper.this.onFieldValueChanged();
                }
            });
            panel = textPanel;
        }
        this.fields.put(labelText, panel);
        return panel.getPanel();
    }

    protected void onFieldValueChanged() {
        this.setValue(this.getCurrentValue());
    }

    protected abstract String getCurrentValue();

    protected abstract Map<String, FieldType> getFields();

    private JPanel makeResultPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createRigidArea(new Dimension(10, 30)));
        this.txtResult = new JTextField();
        panel.add(this.txtResult);
        panel.add(Box.createHorizontalStrut(10));
        this.txtResult.setMaximumSize(BOX_SIZE);
        return panel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum FieldType {
        UNRESTRICTED,
        NUMERIC,
        CHECKBOX,
        ETAG,
        RANGE,
        LIST;

    }
}

