/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.httpbuilder.headerhelpers;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class HeaderHelperBase
extends JDialog {
    private static final Dimension BUTTON_SIZE = new Dimension(60, 30);
    private static final Dimension BUTTON_SPACER = new Dimension(5, 40);
    protected static final Dimension WIDE_SPACER = new Dimension(15, 0);
    private static final Insets BUTTON_MARGIN = new Insets(5, 5, 5, 5);
    private String title;
    private JPanel contentPane;
    private ValueHandler valueHandler;
    private JPanel mainPanel;

    public HeaderHelperBase() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HeaderHelperBase.this.setupBaseGui();
                HeaderHelperBase.this.setupCustomGui(HeaderHelperBase.this.mainPanel);
                HeaderHelperBase.this.customInit();
                HeaderHelperBase.this.pack();
            }
        });
    }

    protected void customInit() {
    }

    private void setupBaseGui() {
        this.setTitle(this.title);
        this.contentPane = new JPanel();
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        this.contentPane.add(this.createTopPanel());
        this.contentPane.add(this.createMainPanel());
        this.contentPane.add(this.createButtonPanel());
    }

    private JPanel createMainPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setBorder(BorderFactory.createEtchedBorder(1));
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        return this.mainPanel;
    }

    private JPanel createTopPanel() {
        JPanel panel = new JPanel();
        panel.add(new JLabel(this.getTitle()));
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        bottomPanel.add(Box.createHorizontalGlue());
        bottomPanel.add(this.createOkButton());
        bottomPanel.add(Box.createRigidArea(BUTTON_SPACER));
        bottomPanel.add(this.createCancelButton());
        bottomPanel.add(Box.createRigidArea(BUTTON_SPACER));
        return bottomPanel;
    }

    private JButton createOkButton() {
        JButton okButton = new JButton("OK");
        okButton.setPreferredSize(BUTTON_SIZE);
        okButton.setMargin(BUTTON_MARGIN);
        okButton.setToolTipText("OK");
        this.getRootPane().setDefaultButton(okButton);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (HeaderHelperBase.this.valueHandler != null) {
                    HeaderHelperBase.this.valueHandler.onValue(HeaderHelperBase.this.getValue());
                }
                HeaderHelperBase.this.dispose();
            }
        });
        return okButton;
    }

    private JButton createCancelButton() {
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setPreferredSize(BUTTON_SIZE);
        cancelButton.setMargin(BUTTON_MARGIN);
        cancelButton.setToolTipText("Cancel");
        this.getRootPane().setDefaultButton(cancelButton);
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HeaderHelperBase.this.dispose();
            }
        });
        return cancelButton;
    }

    protected abstract void setupCustomGui(JPanel var1);

    protected abstract String getValue();

    public void setValueHandler(ValueHandler valueHandler) {
        this.valueHandler = valueHandler;
    }

    public static interface ValueHandler {
        public void onValue(String var1);
    }
}

