/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.httpbuilder.headerhelpers;

import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.noip.codebox.httpbuilder.headerhelpers.HeaderHelperBase;
import net.noip.codebox.httpbuilder.headerhelpers.panels.DateTimePanel;
import net.noip.codebox.httpbuilder.headerhelpers.panels.ETagPanel;
import net.noip.codebox.httpbuilder.headerhelpers.panels.IPanel;
import net.noip.codebox.httpbuilder.headerhelpers.panels.PanelChangeListener;
import net.noip.codebox.httpbuilder.headerhelpers.panels.RadioButtonPanel;

public class IfRangeHeaderHelper
extends HeaderHelperBase {
    private static final Dimension BOX_SIZE = new Dimension(1000, 20);
    private JTextField txtResult;
    private RadioButtonPanel radioPanel;
    private IPanel dateTimePanel;
    private IPanel eTagPanel;
    private static final String ETAG_BTN = "ETag";
    private static final String DATE_BTN = "Date";

    public String getTitle() {
        return "If-Range Header Helper";
    }

    protected void setupCustomGui(JPanel mainPanel) {
        mainPanel.add(this.makeDateTimePanel());
        mainPanel.add(this.makeEtagPanel());
        mainPanel.add(this.makeRadioPanel());
        mainPanel.add(this.makeResultPanel());
        this.radioPanel.setValue(DATE_BTN);
        this.setGuiState();
    }

    private JPanel makeRadioPanel() {
        this.radioPanel = new RadioButtonPanel(new String[]{ETAG_BTN, DATE_BTN});
        this.radioPanel.addChangeListener(new PanelChangeListener(){

            public void onChange(IPanel panel) {
                IfRangeHeaderHelper.this.setGuiState();
            }
        });
        return this.radioPanel.getPanel();
    }

    private void setGuiState() {
        if (DATE_BTN.equals(this.radioPanel.getValue())) {
            this.dateTimePanel.setEnabled(true);
            this.eTagPanel.setEnabled(false);
            this.txtResult.setText(this.dateTimePanel.getValue());
        } else if (ETAG_BTN.equals(this.radioPanel.getValue())) {
            this.dateTimePanel.setEnabled(false);
            this.eTagPanel.setEnabled(true);
            this.txtResult.setText(this.eTagPanel.getValue());
        } else {
            this.dateTimePanel.setEnabled(false);
            this.eTagPanel.setEnabled(false);
            this.txtResult.setText("");
        }
    }

    private JPanel makeEtagPanel() {
        ETagPanel panel = new ETagPanel("");
        panel.addChangeListener(new PanelChangeListener(){

            public void onChange(IPanel panel) {
                IfRangeHeaderHelper.this.txtResult.setText(panel.getValue());
            }
        });
        this.eTagPanel = panel;
        return panel.getPanel();
    }

    protected String getValue() {
        return this.txtResult.getText();
    }

    private JPanel makeDateTimePanel() {
        final DateTimePanel dateTimePanel = new DateTimePanel();
        dateTimePanel.addChangeListener(new PanelChangeListener(){

            public void onChange(IPanel panel) {
                IfRangeHeaderHelper.this.txtResult.setText(dateTimePanel.getValue());
            }
        });
        this.dateTimePanel = dateTimePanel;
        return dateTimePanel.getPanel();
    }

    private JPanel makeResultPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createRigidArea(new Dimension(10, 30)));
        this.txtResult = new JTextField();
        panel.add(this.txtResult);
        panel.add(Box.createHorizontalStrut(10));
        this.txtResult.setMaximumSize(BOX_SIZE);
        return panel;
    }
}

