/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.httpbuilder.headerhelpers.panels;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.noip.codebox.httpbuilder.headerhelpers.panels.IPanel;
import net.noip.codebox.httpbuilder.headerhelpers.panels.PanelChangeListener;

public class RadioButtonPanel
implements IPanel {
    private static final Dimension LABEL_SIZE = new Dimension(70, 20);
    private static final Dimension BOX_SIZE = new Dimension(1000, 20);
    private JPanel panel = new JPanel();
    private JLabel label;
    private ButtonGroup radioButtonGroup;
    private Map<String, JRadioButton> buttons;

    public RadioButtonPanel(String[] names) {
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.buttons = new HashMap<String, JRadioButton>();
        this.radioButtonGroup = new ButtonGroup();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.panel.add(this.makeButtonPanel(name));
            ++n2;
        }
    }

    private JPanel makeButtonPanel(String name) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createRigidArea(new Dimension(10, 10)));
        this.label = new JLabel(name);
        this.label.setPreferredSize(LABEL_SIZE);
        this.label.setMaximumSize(LABEL_SIZE);
        panel.add(this.label);
        JRadioButton radioButton = new JRadioButton("");
        panel.add(radioButton);
        this.radioButtonGroup.add(radioButton);
        this.buttons.put(name, radioButton);
        radioButton.setMaximumSize(BOX_SIZE);
        panel.add(Box.createHorizontalStrut(10));
        return panel;
    }

    public String getName() {
        throw new UnsupportedOperationException("not done");
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public String getValue() {
        String value = null;
        for (String name : this.buttons.keySet()) {
            if (!this.buttons.get(name).isSelected()) continue;
            value = name;
            break;
        }
        return value;
    }

    public void setValue(String value) {
        if (!this.buttons.containsKey(value)) {
            throw new IllegalArgumentException("Bad value for radio button group: '" + value + "' - no button found with this name");
        }
        this.buttons.get(value).setSelected(true);
    }

    public void addChangeListener(final PanelChangeListener listener) {
        for (JRadioButton button : this.buttons.values()) {
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    listener.onChange(RadioButtonPanel.this);
                }
            });
        }
    }

    public void setEnabled(boolean enabled) {
        for (JRadioButton button : this.buttons.values()) {
            button.setEnabled(enabled);
        }
    }

    public void setData(Object data) {
        throw new UnsupportedOperationException("not done");
    }
}

