/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.httpbuilder.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.noip.codebox.httpbuilder.util.ConfigException;
import net.noip.codebox.httpbuilder.util.HeaderData;
import net.noip.codebox.httpbuilder.util.PropertiesFileData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    public static final String APP_NAME = "HttpBuilder";
    public static final String APP_VERSION = "0.2.1";
    public static final String APP_CONTACT = "rob@codebox.no-ip.net";
    public static final String APP_URL = "http://codebox.no-ip.net/controller?page=httpbuilder";
    private static final String APP_DIR = String.valueOf(System.getProperty("user.home")) + File.separator + ".httpbuilder" + File.separator;
    private static final String CUSTOM_HEADER_LIST_KEY = "customheaders";
    private static final String CUSTOM_HEADER_LIST_SEP_CHAR = ",";
    private static HeaderData HEADER_DATA;
    private static PropertiesFileData PROPERTIES_FILE;

    public static String getApplicationDir() {
        File appDir = new File(APP_DIR);
        if (!appDir.exists()) {
            appDir.mkdir();
        }
        return APP_DIR;
    }

    public static void addCustomHeader(String newHeaderName) throws ConfigException {
        List<String> headers = Config.getCustomHeaders();
        if (!headers.contains(newHeaderName)) {
            headers.add(newHeaderName);
            Config.setCustomHeaders(headers);
        }
    }

    public static void removeCustomHeader(String headerNameToRemove) throws ConfigException {
        List<String> headers = Config.getCustomHeaders();
        if (headers.contains(headerNameToRemove)) {
            headers.remove(headerNameToRemove);
            Config.setCustomHeaders(headers);
        }
    }

    public static List<String> getCustomHeaders() throws ConfigException {
        String headerListText = Config.getStringValue(CUSTOM_HEADER_LIST_KEY);
        if (headerListText != null) {
            String[] headerTextParts = headerListText.split(CUSTOM_HEADER_LIST_SEP_CHAR);
            return Arrays.asList(headerTextParts);
        }
        return new ArrayList<String>();
    }

    private static void setCustomHeaders(List<String> headerList) throws ConfigException {
        StringBuilder newHeaderList = new StringBuilder();
        boolean isFirst = true;
        for (String headerName : headerList) {
            if (!isFirst) {
                newHeaderList.append(CUSTOM_HEADER_LIST_SEP_CHAR);
            }
            newHeaderList.append(headerName);
            isFirst = false;
        }
        Config.setStringValue(CUSTOM_HEADER_LIST_KEY, newHeaderList.toString());
    }

    private static HeaderData getHeaderData() throws ConfigException {
        if (HEADER_DATA == null) {
            HEADER_DATA = new HeaderData("headerdata.xml");
        }
        return HEADER_DATA;
    }

    public static synchronized Map<String, String> getValuesForHeader(String headerName) throws ConfigException {
        return Config.getHeaderData().getHeaderValues(headerName);
    }

    private static PropertiesFileData getPropertiesFile() throws ConfigException {
        if (PROPERTIES_FILE == null) {
            PROPERTIES_FILE = new PropertiesFileData("httpbuilder.properties");
        }
        return PROPERTIES_FILE;
    }

    public static String getStringValue(String key) throws ConfigException {
        return Config.getPropertiesFile().getValue(key);
    }

    public static void setStringValue(String key, String value) throws ConfigException {
        Config.getPropertiesFile().setValue(key, value);
    }

    public static int getIntValue(String key) throws NumberFormatException, ConfigException {
        return Integer.parseInt(Config.getStringValue(key));
    }

    public static void setIntValue(String key, int value) throws ConfigException {
        Config.getPropertiesFile().setValue(key, "" + value);
    }

    public static boolean getBooleanValue(String key) throws ConfigException {
        String stringValue = Config.getStringValue(key);
        if ("true".equalsIgnoreCase(stringValue) || "false".equalsIgnoreCase(stringValue)) {
            return Boolean.parseBoolean(stringValue);
        }
        throw new IllegalArgumentException("Unable to convert the value of the key '" + key + "' to a boolean. The value was '" + stringValue + "'");
    }

    public static void setBooleanValue(String key, boolean value) throws ConfigException {
        Config.getPropertiesFile().setValue(key, "" + value);
    }

    public static boolean hasKey(String key) throws ConfigException {
        return Config.getPropertiesFile().hasValue(key);
    }

    public static String removeKey(String key) throws ConfigException {
        return Config.getPropertiesFile().removeValue(key);
    }
}

