/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.httpbuilder.util;

import java.io.File;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.noip.codebox.httpbuilder.util.Log;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HeaderData {
    private Map<String, Map<String, String>> headerData;
    private String file;

    HeaderData(String file) {
        this.file = file;
        SAXBuilder builder = new SAXBuilder();
        try {
            Document document = builder.build(new File(file));
            this.headerData = this.getHeaderData(document);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to process '" + file + "' file - " + e.getMessage(), e);
        }
    }

    private Map<String, Map<String, String>> getHeaderData(Document document) {
        Hashtable<String, Map<String, String>> headers = new Hashtable<String, Map<String, String>>();
        List headerElements = document.getRootElement().getChildren("header");
        for (Object obj : headerElements) {
            Element headerElement = (Element)obj;
            String headerName = headerElement.getAttributeValue("name");
            if (headerName != null) {
                headers.put(headerName, this.getValuesForHeaderElement(headerElement));
                continue;
            }
            Log.warn("missing 'name' attribute on <header> element in " + this.file + ", element will be ignored.");
        }
        return headers;
    }

    private Map<String, String> getValuesForHeaderElement(Element headerElement) {
        assert ("header".equals(headerElement.getName()));
        LinkedHashMap<String, String> headerValues = new LinkedHashMap<String, String>();
        List valueElements = headerElement.getChildren("value");
        for (Object obj : valueElements) {
            Element valueElement = (Element)obj;
            String value = valueElement.getValue();
            String description = valueElement.getAttributeValue("description");
            if (description != null) {
                headerValues.put(description, value);
                continue;
            }
            headerValues.put(value, value);
        }
        return headerValues;
    }

    Map<String, String> getHeaderValues(String header) {
        return this.headerData.get(header);
    }
}

