/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.logmonitor.target;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.noip.codebox.logmonitor.config.ConfigFile;
import net.noip.codebox.logmonitor.config.ILog;
import net.noip.codebox.logmonitor.config.IMonitor;
import net.noip.codebox.logmonitor.target.AbstractMonitor;
import net.noip.codebox.logmonitor.target.IMonitorable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Factory {
    private static Logger logger = Logger.getLogger("net.noip.codebox.logmonitor.target.Factory");
    Map<String, IMonitorable> logObjectMap = new LinkedHashMap();
    Map<String, ILog> logDetailsMap;
    Map<String, String> configData;

    public Factory(ConfigFile configFile) {
        logger.info("Loading targets...");
        this.logDetailsMap = configFile.getLogMap();
        Map map = configFile.getMonitorMap();
        this.configData = configFile.getConfigMap();
        for (ILog iLog : this.logDetailsMap.values()) {
            String string = iLog.getType();
            String string2 = iLog.getName();
            IMonitor iMonitor = (IMonitor)map.get(string);
            if (iMonitor != null) {
                try {
                    Constructor constructor = iMonitor.getClassObject().getConstructor(String.class, String.class);
                    AbstractMonitor abstractMonitor = (AbstractMonitor)constructor.newInstance(string2, iLog.getLocation());
                    abstractMonitor.setFilter(iLog.getFilter());
                    string2 = iLog.getName();
                    this.logObjectMap.put(string2, abstractMonitor);
                    logger.info("Loaded target '" + string2 + "' OK.");
                }
                catch (Exception exception) {
                    logger.warning("Unable to create a monitor for the log '" + iLog + "' which requires an instance of the class '" + iMonitor.getClassObject().getName() + "'. The original error was: " + exception.getMessage() + ". Skipping this log.");
                }
                continue;
            }
            logger.warning("Unknown log type of '" + string + "' was specified for log '" + iLog.getName() + "'. Skipping this log.");
        }
        logger.info("Loading targets complete.");
    }

    public synchronized List<String> getTargetNames() {
        return new ArrayList<String>(this.logObjectMap.keySet());
    }

    public synchronized IMonitorable getTarget(String string) {
        if (this.logObjectMap.containsKey(string)) {
            return (IMonitorable)this.logObjectMap.get(string);
        }
        return null;
    }

    public synchronized Map<String, ILog> getLogDetails() {
        return Collections.unmodifiableMap(this.logDetailsMap);
    }

    public synchronized Map<String, String> getConfigData() {
        return Collections.unmodifiableMap(this.configData);
    }
}

