/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.logmonitor.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import net.noip.codebox.logmonitor.config.ILog;
import net.noip.codebox.logmonitor.config.IOptions;
import net.noip.codebox.logmonitor.config.IStyle;
import net.noip.codebox.logmonitor.target.Factory;
import net.noip.codebox.logmonitor.target.IMonitorable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ResponseBuilder {
    public static void makeErrorResponse(HttpServletResponse httpServletResponse, String string) throws IOException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"error", (Object)string);
        ResponseBuilder.sendResponse((HttpServletResponse)httpServletResponse, (String)jSONObject.toString());
    }

    public static void makeResponseGetLatest(HttpServletResponse httpServletResponse, String string, List<List<String>> list) throws IOException {
        JSONArray jSONArray = new JSONArray();
        for (List<String> list2 : list) {
            JSONArray jSONArray2 = new JSONArray();
            for (String string2 : list2) {
                jSONArray2.add((Object)string2);
            }
            jSONArray.add((Object)jSONArray2);
        }
        ResponseBuilder.sendResponse((HttpServletResponse)httpServletResponse, (String)jSONArray.toString());
    }

    public static void makeResponseListTargets(HttpServletResponse httpServletResponse, Factory factory) throws IOException {
        Map map = factory.getLogDetails();
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        for (ILog iLog : map.values()) {
            List list;
            IMonitorable iMonitorable = factory.getTarget(iLog.getName());
            if (iMonitorable == null) continue;
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put((Object)"name", (Object)iLog.getName());
            jSONObject2.put((Object)"lastQueryTime", (Object)new Date().getTime());
            IOptions iOptions = iLog.getDefaultOptions();
            if (iOptions != null) {
                if (iOptions.isShowDividers() != null) {
                    jSONObject2.put((Object)"showDividers", (Object)iOptions.isShowDividers());
                }
                if (iOptions.getInterval() != null) {
                    jSONObject2.put((Object)"refreshInterval", (Object)iOptions.getInterval());
                }
                if (iOptions.getLines() != null) {
                    jSONObject2.put((Object)"lineCount", (Object)iOptions.getLines());
                }
            }
            if ((list = iLog.getDefaultStyles()) != null) {
                JSONArray jSONArray2 = new JSONArray();
                for (IStyle iStyle : list) {
                    JSONObject jSONObject3 = new JSONObject();
                    if (iStyle.isVisible() != null) {
                        jSONObject3.put((Object)"visible", (Object)iStyle.isVisible());
                    }
                    if (iStyle.getForeColour() != null) {
                        jSONObject3.put((Object)"foreColour", (Object)iStyle.getForeColour());
                    }
                    if (iStyle.getBackColour() != null) {
                        jSONObject3.put((Object)"backColour", (Object)iStyle.getBackColour());
                    }
                    jSONArray2.add((Object)jSONObject3);
                }
                jSONObject2.put((Object)"colStyles", (Object)jSONArray2);
            }
            jSONArray.add((Object)jSONObject2);
        }
        jSONObject.put((Object)"targets", (Object)jSONArray);
        ResponseBuilder.sendResponse((HttpServletResponse)httpServletResponse, (String)jSONObject.toString());
    }

    public static void makeResponseHasUpdated(HttpServletResponse httpServletResponse, String string, long l, boolean bl) throws IOException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"lastUpdateTime", (Object)l);
        jSONObject.put((Object)"hasUpdated", (Object)bl);
        ResponseBuilder.sendResponse((HttpServletResponse)httpServletResponse, (String)jSONObject.toString());
    }

    public static void makeResponseConfigData(HttpServletResponse httpServletResponse, Map<String, String> map) throws IOException {
        JSONObject jSONObject = new JSONObject();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            jSONObject.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        ResponseBuilder.sendResponse((HttpServletResponse)httpServletResponse, (String)jSONObject.toString());
    }

    private static void sendResponse(HttpServletResponse httpServletResponse, String string) throws IOException {
        httpServletResponse.setContentType("application/json");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.print(string);
        printWriter.close();
    }
}

